
#ifndef MEETINGACCOUNTCONTROLLERIMPL_H
#define MEETINGACCOUNTCONTROLLERIMPL_H

#include "csfunified/services/impl/base/MeetingAccountControllerBaseImpl.h"
#include "csfunified/services/interface/MeetingAccountCallback.h"

namespace CSFUnified
{

    class MeetingAccountControllerImpl : public MeetingAccountControllerBaseImpl
    {
    public:
        ~MeetingAccountControllerImpl();
        static MeetingAccountControllerImpl * getInstance();

        void start();
        void stop();

        virtual void registerMeetingAccountCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountCallback> meetingAccountCallback);
        virtual void unregisterMeetingAccountCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountCallback> meetingAccountCallback);
		virtual bool isReady();
		virtual bool isActive();
        virtual int getMeetingSiteCount();
        virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> getMeetingSiteByIndex(int index);
		virtual SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> getDefaultMeetingSite();
		virtual void checkSSOSite(std::string siteUrl);
		virtual int isSSOSite(std::string siteUrl);
        virtual void setActiveSite(std::string siteUrl, std::string userName, const csf::SecureString& userPass);
        virtual void setActiveSite(std::string siteUrl, std::string userName, std::string sessionTicket, long keepAliveTime);
        virtual void removeSite(std::string siteUrl);
        virtual int getSiteLastError();
		virtual std::string getSiteLastErrorMessage();

		void fire_onMeetingSiteActived(bool activeFlag, std::string siteUrl, SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> site);
        void fire_onSSOSiteChecked(std::string siteUrl, int ssoFlag);
        void fire_onMeetingSiteRemoved(std::string siteUrl);
        void fire_requireRefreshSessionTicket(std::string siteUrl, bool refresh);
        
        void networkChanged(bool bConnected);
        
    private:
        MeetingAccountControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
        
    private:
        MeetingAccountCallback * m_maCallback;
        
        bool m_bTimerStarted;
    };
}

#endif
